/*{
    "DESCRIPTION": "Mixer",
    "CREDIT": "",
    "ISFVSN": "2",
    "CATEGORIES": [
        "Composition"
    ],
    "INPUTS": [
        {
            "NAME": "inputImage",
            "TYPE": "image"
        },
        {
            "NAME": "topImage",
            "TYPE": "image"
        },
        {
            "NAME": "dryWet",
            "TYPE": "float",
            "DEFAULT": 1.0,
            "MIN": 0.0,
            "MAX": 1.0
        },
         {
             "NAME": "blackOut",
             "TYPE": "bool",
             "DEFAULT": true
         }
    ]
    
}*/

vec4 blendSubtract(vec4 x, vec4 y, float opacity) {
    return max(x + y - 1.0, 0.0) * opacity + x * (1.0 - opacity);
}

void main() {
    vec4 bottom = IMG_NORM_PIXEL(inputImage, isf_FragNormCoord);
    vec4 top = IMG_NORM_PIXEL(topImage, isf_FragNormCoord);
    
    gl_FragColor = blendSubtract(bottom, top, dryWet);
}
