/*{
    "DESCRIPTION": "Mixer",
    "CREDIT": "",
    "ISFVSN": "2",
    "CATEGORIES": [
        "Composition"
    ],
    "INPUTS": [
        {
            "NAME": "inputImage",
            "TYPE": "image"
        },
        {
            "NAME": "topImage",
            "TYPE": "image"
        },
        {
            "NAME": "dryWet",
            "TYPE": "float",
            "DEFAULT": 1.0,
            "MIN": 0.0,
            "MAX": 1.0
        }
    ]
    
}*/

const float SQRT_2 = 1.414213562373;
const float smoothness = 0.3;

void main() {
    float minSize = min(RENDERSIZE.x, RENDERSIZE.y);
    vec2 ratio = vec2(RENDERSIZE.x / minSize, RENDERSIZE.y / minSize);
    vec2 center = 0.5 * ratio;
    vec2 uv = isf_FragNormCoord * ratio;

    float x = 1.-dryWet;
    float m = smoothstep(-smoothness, 0.0, distance(center, uv) - x*(1.+smoothness));
    gl_FragColor = mix(IMG_NORM_PIXEL(inputImage, isf_FragNormCoord), IMG_NORM_PIXEL(topImage, isf_FragNormCoord), m);
    
}
