/*{
    "DESCRIPTION": "Mixer",
    "CREDIT": "",
    "ISFVSN": "2",
    "CATEGORIES": [
        "Composition"
    ],
    "INPUTS": [
        {
            "NAME": "inputImage",
            "TYPE": "image"
        },
        {
            "NAME": "topImage",
            "TYPE": "image"
        },
     {
         "NAME": "dryWet",
         "TYPE": "float",
         "DEFAULT": 1.0,
         "MIN": 0.0,
         "MAX": 1.0
     }
    ]
    
}*/

void main() {
    vec4 bottom = IMG_NORM_PIXEL(inputImage, isf_FragNormCoord);
    vec4 top = IMG_NORM_PIXEL(topImage, isf_FragNormCoord);
    
    float blendTop = max(0.0, (dryWet - 0.5) * 2.0);

    gl_FragColor = vec4(abs((bottom.rgb * (1.0 - blendTop)) - top.rgb * dryWet), 1.0);

}
