/*{
    "DESCRIPTION": "Mixer",
    "CREDIT": "",
    "ISFVSN": "2",
    "CATEGORIES": [
        "Composition"
    ],
    "INPUTS": [
        {
            "NAME": "inputImage",
            "TYPE": "image"
        },
        {
            "NAME": "topImage",
            "TYPE": "image"
        },
        {
            "NAME": "dryWet",
            "TYPE": "float",
            "DEFAULT": 1.0,
            "MIN": 0.0,
            "MAX": 1.0
        }
    ]
    
}*/

void main() {
    vec4 bottom = IMG_NORM_PIXEL(inputImage, isf_FragNormCoord);
    vec4 top = IMG_NORM_PIXEL(topImage, isf_FragNormCoord);
    
    float amntBot = min(1.0, dryWet * 2.0);
    float amntTop = max(0.0, -1.0 + dryWet * 2.0);

    vec4 returnMe = bottom * (1.0 - amntTop) + top * amntBot;
    returnMe.a = 1.0;
        
    gl_FragColor = mix(returnMe, top, amntTop);
}

    
