/*
{
  "CATEGORIES" : [
    "Geometry Adjustment"
  ],
  "DESCRIPTION" : "Warp to fit",
  "ISFVSN" : "2",
  "INPUTS" : [
    {
      "NAME" : "inputImage",
      "TYPE" : "image"
    },
    {
      "NAME" : "zoom",
      "TYPE" : "float",
      "MAX" : 1,
      "DEFAULT" : 0.5,
      "MIN" : 0
    },
    {
      "NAME" : "x",
      "TYPE" : "float",
      "DEFAULT" : 0.5
    },
     {
       "NAME" : "y",
       "TYPE" : "float",
       "DEFAULT" : 0.5
     },
     {
       "NAME" : "flipX",
       "TYPE" : "bool",
       "DEFAULT" : false
     },
    {
        "NAME" : "flipY",
         "TYPE" : "bool",
         "DEFAULT" : false
    }
 
  ],
  "CREDIT" : "RV"
}
*/

void main() {
    vec2 uv = isf_FragNormCoord;

    // Precompute constants
    vec2 texSize = IMG_SIZE(inputImage);
    vec2 renderSize = RENDERSIZE;
    float textureAspect = texSize.x / texSize.y;
    float frameAspect = renderSize.x / renderSize.y;
    float textureFrameRatio = textureAspect / frameAspect;

    // Compute scaling factors
    float scaleX = frameAspect >= 1.0 ? 1.0 / textureFrameRatio : 1.0;
    float scaleY = frameAspect < 1.0 ? textureFrameRatio : 1.0;
    scaleX *= flipX ? -1.0 : 1.0;
    scaleY *= flipY ? -1.0 : 1.0;
    
    // Compute zoom amount
    float zoomAmount = exp(-3.0 + (1.0 - zoom) * 6.0);

    // Apply translation and scaling
    uv -= vec2(-1.0 + x * 2.0, -1.0 + y * 2.0);
    uv = (uv - 0.5) * zoomAmount * vec2(scaleX, scaleY) + 0.5;

    // Check if UV is within bounds
    if (uv.x >= 0.0 && uv.y >= 0.0 && uv.x <= 1.0 && uv.y <= 1.0) {
        gl_FragColor = IMG_NORM_PIXEL(inputImage, uv);
    } else {
        gl_FragColor = vec4(0.0);
    }
}
